function [RGBcolors,h]=PlotBoundaries02(varargin)
% function RGBcolors=PlotBoundaries02(varargin)
%   To plot boundaries with labels for a 3D mesh
%   Requires a prior call to BuildBoundaryMeshes to define Bh.
%
% parameters:
%   Bh  : boundary mesh structure (obtained by BuildBoundaryMeshes)
%   RGBcolors : (array of doubles) Array of values to set RGB values of the mesh lines. Each region may be identified by a different RGB. Default value is the empty array.
%   Color : (string) To define the color of mesh lines. Default value is the empty string.
%   Legend :  (bool) To display the legend or not. Default value is true.
%   FontSize :  (integer) To set the font size of the legend. Default value is 10.
%   labels : (array of integers). To plot only specific regions. Default value is the empty array.

  p = inputParser; 
  p=mVisuMesh.utils.AddRequired(p,'Bh', @isstruct);
  p=mVisuMesh.utils.AddParamValue(p,'RGBcolors', [], @isnumeric );
  p=mVisuMesh.utils.AddParamValue(p,'Color', '', @ischar );
  p=mVisuMesh.utils.AddParamValue(p,'Legend', true , @islogical );
  p=mVisuMesh.utils.AddParamValue(p,'FontSize', 10 , @isnumeric );
  p=mVisuMesh.utils.AddParamValue(p,'labels', [], @isnumeric ); % @(v) isempty(setdiff(v,BL))
  p=mVisuMesh.utils.Parse(p,varargin{:});
  
  R=p.Results;
  Bh=R.Bh;

  BL=zeros(length(Bh),1);for i=1:length(Bh),BL(i)=Bh(i).label;end;
  AllLabs=BL;
  if ~isempty(R.labels) 
    if isempty(setdiff(R.labels,BL))
      BL=R.labels;
    else
      error('Wrong labels');
    end
  end
  nLab=length(BL);

  BL=reshape(BL,1,nLab);
  RGBcolors=ChooseColor(R,nLab);
  cLegend=cell(1,nLab);
  h=zeros(nLab,1);
  PrevHold=SetHoldOn(true);
%  hold on
  % -> BUG Octave 4.2.0: 
  %  error: out of memory or dimension too large for Octave's index type
  % Occurs when axis in not in 3D
  [A,Z]=view();
  if A==0, view(3);end
  % <- BUG Octave 4.2.0: 
  for l=BL
    i=find(AllLabs==l);
    indx=find(l==BL);
    h(indx)=trimesh(Bh(i).me',Bh(i).q(1,:),Bh(i).q(2,:),Bh(i).q(3,:), ...
              'EdgeColor',[0,0,0],'FaceColor',RGBcolors(indx,:),'FaceAlpha',1);
              %'EdgeColor',RGBcolors(indx,:),'FaceColor',RGBcolors(indx,:),'FaceAlpha',0.5);
%    hold on
    if mVisuMesh.utils.isOctave()
      cLegend{indx}=sprintf('\\Gamma_{%d}',l);
    else
      cLegend{indx}=sprintf('$\\Gamma_{%d}$',l);
    end
  end
  if R.Legend
    H=legend(h,cLegend);
    if mVisuMesh.utils.isOctave()
      set(H,'FontSize',R.FontSize,'interpreter','tex','location','eastoutside');
    else
      set(H,'FontSize',R.FontSize,'interpreter','latex');
    end
  end
% -> BUG with Octave 420
%  When only boundaries on xOy are plotted with view(3), axis image or axis equal failed!
%axis equal;
%axis image;
% <- BUG with Octave 420
RestoreHold(PrevHold)
end
