function h=PlotVal(varargin)
% function h=PloVal(varargin)
%   To plot a nodal variable on a 2D mesh
%
% parameters:
%   Th  : mesh structure
%   Val : `2\times\nq` array of doubles
%
% Optional parameters (of type addParameter):
%   CameraPosition : array of two doubles to set the camera position. Default value is "view(2)"
%   colormap : To set colormap value to \'jet\', \'hsv\', \'gray\',
%   \'colorcube\',\'cool\',\'spring\',\'summer\',..  Default value is 'jet'.
%   shading : To use shading interp if true. Default value is true
%   colorbar : To set colorbar visible if true. Default value is true
%   labels:  array of labels (integer) to plot only specific regions. 
%   caxis: array of four doubles to set the axis. Default value is an empty array.

% Example:
%  @verbatim
%   PlotVal(Th,u,'colormap','cool');@endverbatim
%  \image html images/PlotVal.png "figure : PlotVal(Th,u,\'colormap\',\'cool\');"
p = inputParser;

%
p=AddRequired(p,'Th', @isstruct);
p=AddRequired(p,'Val', @isnumeric);
p=AddParamValue(p,'CameraPosition', [], @isnumeric );
p=AddParamValue(p,'colormap', 'jet' , @ischar );
p=AddParamValue(p,'shading', true , @islogical );
p=AddParamValue(p,'plan', false , @islogical );
p=AddParamValue(p,'colorbar', true , @islogical );
p=AddParamValue(p,'caxis', [] , @isnumeric );
p=AddParamValue(p,'labels', [], @isnumeric ); % @(v) isempty(setdiff(v,unique(Th.mel)))
p=Parse(p,varargin{:});

R=p.Results;
Th=R.Th;

colormap(R.colormap)
ListSubDomLabel=unique(Th.mel);
if ~isempty(R.labels) 
  if isempty(setdiff(R.labels,ListSubDomLabel))
    ListSubDomLabel=R.labels;
  else
    error('Wrong labels');
  end
end

ListSubDomLabel=reshape(ListSubDomLabel,1,length(ListSubDomLabel));
PrevHold=SetHoldOn(true);
for i=ListSubDomLabel
  I=find(Th.mel==i);
  if R.plan
    H=patch('Vertices',Th.q','Faces',Th.me(:,I)','CData',R.Val,'FaceColor','interp');
  else
    H=trisurf(Th.me(:,I)',Th.q(1,:),Th.q(2,:),R.Val);
  end
end
if nargout==1, h=H;end
%xmin=min(Th.q(1,:));xmax=max(Th.q(1,:));
%ymin=min(Th.q(2,:));ymax=max(Th.q(2,:));
if ~isempty(R.caxis)
    caxis(R.caxis)
end
if R.shading
    shading interp
end
if isempty(R.CameraPosition)
    view(2)
    %set(gca,'CameraPosition',[(xmin+xmax)/2 (ymin+ymax)/2 10])
else
    set(gca,'CameraPosition',R.CameraPosition)
end
if R.colorbar
    colorbar
end
axis image
axis off