function Mesh=GetMesh3DOpt(cFileName,varargin)
% Mesh=GetMesh3DOpt(cFileName,varargin)
%   Read 3D-mesh in format :
%     - FreeFem++= medit,
%     - gmsh.
%
% Parameter :
%   cFileName : mesh filename 
% Optional parameter :
%   'format' : 'freefem' (default) , 'gmsh' or 'medit'(='freefem')
%   'dim'    : 3 (default) - integer
% Output :
%   Mesh, a mesh structure (see setMesh.m)
%
  p = inputParser; 
  p=AddParamValue(p,'format', 'freefem', @(v) ismember(v,{'freefem','medit','gmsh'}));
  p=AddParamValue(p,'dim', 3, @isfloat );
  p=Parse(p,varargin{:});

  R=p.Results;
  Format=R.format;
  dim=R.dim;
  % FC -> a ameliorer avec une liste des formats dispo et 
  %       utilisation + generique GetMesh%s...

% Ancienne version
%  if (strcmp(Format,'freefem')) 
%    Mesh=GetFreefemMesh(cFileName);
%  end
%  if (strcmp(Format,'medit'))
%    Mesh=GetMeditMesh(cFileName);
%  end

% Nouvelle version 09/15 plus efficace pour format 'medit' (pas de retour au début du fichier)
  if (strcmp(Format,'freefem') || strcmp(Format,'medit') )
   Mesh=GetMeshMedit(cFileName,'dim',dim);
  end


  if strcmp(Format,'gmsh')
% 09/15 il vaut mieux utiliser gmsh2mesh et gmsh2mesh_octave plutot que GetGmshMesh
     if isOctave()
       Mesh=gmsh2mesh_octave(cFileName,'dim',dim);
     else
       Mesh=gmsh2mesh(cFileName,'dim',dim);
     end
% Ancienne version
%    Mesh=GetGmshMesh(cFileName);
  end

end


% Read medit meshes
% A comparer a GetMeshMedit.m (qui est mieux)
function Mesh=GetMeditMesh(cFileName)
  [fid,message]=fopen(cFileName,'r');
   if ( fid == -1 )
     error([message,' : ',cFileName]);
   end
  if isOctave()
    % Read Vertices
    tline='';
    while ~strcmp(strtrim(tline),'Vertices')
        tline = fgetl(fid);
        if (tline ==-1)
          error('Error : Vertices not found');
        end
    end
    nq=fscanf(fid,'%d',1);
    R=fscanf(fid,'%f %f %f %d',[4,nq]);
    q=R([1 2 3],:);
    ql=R(4,:);
    
    % Read Triangles
    fclose(fid);
    [fid,message]=fopen(cFileName,'r');
    while ~strcmp(strtrim(tline),'Triangles')
        tline = fgetl(fid);
        if (tline ==-1)
          error('Error : Triangles not found');
        end
    end
    nbe=fscanf(fid,'%d',1);
    R=fscanf(fid,'%d %d %d %d',[4,nbe]);   
    be=R([1 2 3],:);
    bel=R(4,:);
    
    % Read Tetrahedra
    fclose(fid);
    [fid,message]=fopen(cFileName,'r');
    tline='';
    while ~strcmp(strtrim(tline),'Tetrahedra')
        tline = fgetl(fid);
        if (tline ==-1)
          error('Error : Tetrahedra not found');
        end
    end
    nme=fscanf(fid,'%d',1);
    R=fscanf(fid,'%d %d %d %d %d',[5,nme]);  
    me=R([1:4],:);
    mel=R(5,:);
  else % Matlab
    tline='';
    while ~strcmp(strtrim(tline),'Vertices')
        tline = fgetl(fid);
    end
    nq=fscanf(fid,'%d',1);
    R=textscan(fid,'%f %f %f %d',nq);
    q=[R{1},R{2},R{3}]';
    ql=R{4}';
    fclose(fid);
    [fid,message]=fopen(cFileName,'r');
    tline='';
    while ~strcmp(strtrim(tline),'Triangles')
        tline = fgetl(fid);
    end
    nbe=fscanf(fid,'%d',1);
    
    R=textscan(fid,'%d %d %d %d',nbe);
    be=[R{1},R{2},R{3}]';
    bel=R{4}';
    fclose(fid);
    [fid,message]=fopen(cFileName,'r');
    tline='';
    while (~strcmp(strtrim(tline),'Tetrahedra'))
        tline = fgetl(fid);
    end
    % Apres Tetrahedra
    nme=fscanf(fid,'%ld',1);
    
    R=textscan(fid,'%d %d %d %d %d',nme);
    me=[R{1},R{2},R{3},R{4}]';
    mel=R{5}';
  end
  fclose(fid);
  Mesh=setMesh(3,nq,nme,nbe,q,double(me),double(be),double(mel),double(bel),'name',cFileName,'format','medit');  
%    Mesh=struct('d',3,'q',q,'me',double(me),'ql',ql,'mel',double(mel), ...
%                'be',double(be),'bel',double(bel), ...
%                'nq',nq, ...
%                'nme',nme, ...
%                'nbe',nbe, ...
%                'vols',ComputeVolVec(3,q,me), ...
%                'h',GetMaxLengthEdges(q,me));
if Mesh.nq==0 || Mesh.nme==0
   warning('nq or nme is zero! Maybe mesh reading is wrong!');
end
end
