% PlotEdgeNumberfull.m
% Demo of PlotEdgeNumber function
% PlotMesh, PlotBounds, PlotNodeNumber and PlotTriangleNumber are also used.
% The mesh is provided by the meshes.tar.gz archive.
% This figure is included in the report to describe the mesh structure.
Th=GetMeshOpt('Ring-3.msh',2);
PlotMesh(Th,'RGBcolors', selectColors(length( unique(Th.bel))+1));
RGBcolors=PlotBounds(Th,'FontSize',15);
PlotEdgeNumber(Th,'RGBEdgeColors', RGBcolors, 'Color',[0 0 0],'LineStyle','-', 'LineWidth',0.5,'FontSize',12);
PlotNodeNumber(Th,'Color',[0 0 1],'FontSize',12);
PlotTriangleNumber(Th,'Color',[1 0 0],'FontSize',12);
%set(legend(),'FontSize',24);
if ~isOctave()
set(legend(),'Location','BestOutside');
end
