% PlotVal3Dcyl.m
%  Demo of PlotVal3D function for a 3D mesh
%  PlotOptions option is used for PlotVal3D.
%  The mesh is provided by the meshes.tar.gz archive.
Th=GetMeshOpt('cylinderkey-10.msh',3, 'format','gmsh');
f=@(x,y,z) x.^2+y.^2+cos((z-1).^2);
U=f(Th.q(1,:),Th.q(2,:),Th.q(3,:));
set(legend(),'FontSize',24);
if isOctave()
  PlotVal3D(Th,U,'shading',false) % 'EdgeAlpha' property not implemented in patch function?
else
  PlotVal3D(Th,U,'PlotOptions', {'EdgeAlpha',0.1});
  set(legend(),'Location','BestOutside');
  set(colorbar(),'Fontsize',13);
end
