function Th=GetMeshMedit(cFileName,varargin)
% Mesh=GetMeshMedit(cFileName)
%   Reading a mesh in format medit obtained by:
%     - FreeFem++,
%     - gmsh.
%
%   Should be faster than GetMesh3DOpt (with or without 'format','medit')
%
% Parameter :
%   cFileName : mesh filename
% Output :
%   Mesh, a mesh structure (see setMesh.m)
%
p = inputParser;
p=AddParamValue(p,'dim', 3, @isfloat ); % default dim is 3
p=AddParamValue(p,'d', -1, @isfloat ); % default d is dim
p=Parse(p,varargin{:});
dim=p.Results.dim;

Th=setMesh();

Th.dim=dim;
Th.d=p.Results.d;
if Th.d==-1,Th.d=dim;end;
% definition of fid
[fid,message]=fopen(cFileName,'r');

if ( fid == -1 )
    error([message,' : ',cFileName]);
end

% mesh keyword list
keywords={'Vertices','Triangles','Tetrahedra','Edges'};

funcs_read=cell(length(keywords),1);
funcs_read{1}=@(fid,Th) read_vertices(fid,Th,dim);
funcs_read{2}=@(fid,Th) read_boundary_connectivity(fid,Th);
funcs_read{3}=@(fid,Th) read_mesh_connectivity(fid,Th);

readingFile =true; % true if inside the file
while ( readingFile )
    text = fgetl ( fid );
    if ( text == -1 )
        readingFile=false;
    else
        [iskeyw,ik]=ismember(strtok(text),keywords);
        if(iskeyw)
            numf=fnum(ik,Th.d);
            if(numf), Th=funcs_read{numf}(fid,Th); end
        end
    end
end
fclose(fid);
Th.vols=ComputeVolVec(Th.d,Th.q,Th.me);
Th.h=GetMaxLengthEdges(Th.q,Th.me);
Th.hmin=GetMinLengthEdges(Th.q,Th.me);
Th=setMeshInfo(Th,'name',cFileName,'format','medit');
end


% reading of q variables
%
function Th=read_vertices(fid,Th,dim)
d=Th.d;
Th.nq=fscanf(fid,'%d',1);
if isOctave()
    R=fscanf(fid,[repmat('%f ',1,3),'%d'],[4,Th.nq]);
    Th.q=R([1:d],:);
    ql=R(4,:);
else
    R=textscan(fid,[repmat('%f ',1,3),'%d'],Th.nq);
    %    Th.q=[R{1},R{2},R{3}]';
    Th.q=[R{1:d}]';
    ql=R{4}';
end
if(dim>d)
    Th.q=[Th.q;zeros(dim-d,size(Th.q,2))];
end
end

% reading of me variables (number of mesh elements and mesh connectivity)
%
function Th=read_mesh_connectivity(fid,Th)
d=Th.d;Th.nme=fscanf(fid,'%d',1);
if isOctave()
    R=fscanf(fid,repmat('%d ',1,d+2),[d+2,Th.nme]);
    Th.me=R([1:d+1],:);
    Th.mel=R(d+2,:);
else
    R=textscan(fid,repmat('%f ',1,d+2),Th.nme);
    Th.me=[R{1:d+1}]';
    Th.mel=R{d+2}';
end
end

% reading of be variables (number of boundary mesh elements and boundary mesh connectivity)
%
function Th=read_boundary_connectivity(fid,Th)
d=Th.d;Th.nbe=fscanf(fid,'%d',1);
if isOctave()
    R=fscanf(fid,repmat('%d ',1,d+1),[d+1,Th.nbe]);
    
    Th.be=R(1:d,:);
    Th.bel=R(d+1,:);
else
    R=textscan(fid,repmat('%d ',1,d+1),Th.nbe);
    Th.be=[R{1:d}]';
    Th.bel=R{d+1}';
end
end

%
% function number depending on d
%
% d=2, (ik=2) Triangles-> mesh_connectivity (numf=3)
% d=3, (ik=2) Triangles-> boundary_connectivity (numf=2)
% d=2, (ik=4) Edges-> boundary_connectivity (numf=2)
% d=3, (ik=3) Tetrahedra-> mesh_connectivity (numf=3)
%
function numf=fnum(ik,d)
switch d
    case 3
        numf=ik;
        if (ik==4)
            numf=0;
        end
    case 2
        switch ik
            case 1
                numf=ik;
            case 2
                numf=3;
            case 3
                numf=0;
            case 4;
                numf=2;
        end
end
end
