function post_install(S)
  fprintf('To use demo files, ovisumesh needs some mesh files.\n')
  goAgain = true;
  while goAgain
    resp=input('Do you want to download them (~1Mo) [Y/N] ? ','s');
    resp=upper(resp);
    goAgain=~ismember(resp,{'Y','N'});
 end
 if isequal(resp,'Y');
   v=S.version;
   file='meshes.tar.gz';
   fprintf('Downloading and unpacking mesh file archive ...')
   http=sprintf('http://www.math.univ-paris13.fr/~cuvelier/software/codes/VisuMesh/%s/meshes.tar.gz',v);
   [filepath, success, message] = urlwrite(sprintf('http://www.math.univ-paris13.fr/~cuvelier/software/codes/VisuMesh/%s/meshes.tar.gz',v),file);
   % even if failed to download success is Ok because urlwrite get the default html page
   failed=false;
   try
     [filepath, success, message] = urlwrite(sprintf('http://www.math.univ-paris13.fr/~cuvelier/software/codes/VisuMesh/%s/meshes.tar.gz',v),file);
     file=unpack(filepath,S.dir,'targz');
   catch 
     failed=true;
     fprintf(' [Failed]\n');
     fprintf(' Unable to download and/or unpack file %s from:\n',file);
     fprintf('   %s\n',http)
     warning('Installation of mesh files failed!')
   end
   if ~failed
     fprintf(' [OK]\n')
     fprintf(' Mesh files directory:\n   %s\n',[S.dir,filesep,'meshes'])
     % meshes directory wil be automaticaly delete when uninstall package
 end
end
  