% Plot3DSurfIsolines1
%  Demo of Plot3DSurfIsolines function
%  The mesh is provided by the meshes.tar.gz archive.
Th=GetMeshOpt('cylinderkey-10.msh',3, 'format','gmsh');
f=@(x,y,z) x.^2+y.^2+cos((z-1).^2);
U=f(Th.q(1,:),Th.q(2,:),Th.q(3,:));
Plot3DSurfIsolines(Th,U,'labels', [10,11,31,2000,2020,2021],'niso', 15,'PlotOptions', {'LineWidth',1})
view(3);
if ~isOctave()
  set(legend(),'FontSize',24);
  set(legend(),'Location','BestOutside');
  set(colorbar(),'Fontsize',13);
end
