function varargout=PlotBounds(Th,varargin)
% function varargout=PlotBounds(Th,varargin)
%   Plotting boundaries with labels for a 2D or 3D mesh
%
% Parameters:
%   Th  : mesh structure
%
% Optional parameters (of type addParameter):
%   LineWidth : (double) To set the line width of boundaries. Default value is 2.
%   Color : (string) To define the color of boundaries. Default value is the empty string.
%   RGBcolors : (array of doubles) Array of RGB values to set RGB values of the boundaries. Each region may be identified by a different RGB. Default value is the empty array.
%   Legend :  (bool) To display the legend or not. Default value is true.
%   FontSize :  (integer) To set the font size of the legend. Default value is 10.
%   labels : (array of integers). To plot only specific regions. Default value is the empty array.
%
% Return values:
%  varargout: array of the RGB colors used by the plot.
%
% Example:
%   PlotBounds(Th,'LineWidth',3);
%

%  @verbatim 
%   PlotBounds(Th,'LineWidth',2);@endverbatim
%  \image html images/PlotBounds.png "figure : PlotBounds(Th,\'LineWidth\',2);" 
%
switch Th.d
case 2
RGBcolors=PlotBounds2D(Th,varargin{:});
case 3
Bh=BuildBoundaryMeshes(Th);
[RGBcolors,h]=PlotBoundaries02(Bh,varargin{:});
otherwise
error('Unknown mesh dimension. Unable to plot');
end
if nargout>=1
varargout{1}=RGBcolors;
end
if nargout==2
varargout{2}=h;
end
end
