function h=PlotVal3D(varargin)
% function h=PlotVal3D(varargin)
%   To plot a nodal variable on a 3D mesh.
%
% parameters:
%   Th  : mesh structure
%   Val : `3\times\nq` array of doubles
%
%  Optional parameters (of type addParameter):
%   colormap : To set colormap value to \'jet\', \'hsv\', \'gray\',
%   \'colorcube\',\'cool\',\'spring\',\'summer\',..  Default value is 'jet'.
%   shading : To use shading interp if true. Default value is true
%   colorbar : To display the colorbar or not. Default value is true.
%   caxis : array of four doubles to set the axis. Default value is an empty array.
%   PlotOptions : a cell to define plotting options. Default value is an empty cell.
%
%  Optional output argument:
%   h is the handle to the figure

%  if isOctave
%    warning('Not yet implemented')
%    h=[];
%    return
%  end
p = inputParser;

%
p=AddRequired(p,'Th', @isstruct);
p=AddRequired(p,'Val', @isnumeric);
p=AddParamValue(p,'colormap', 'jet' , @ischar );
p=AddParamValue(p,'shading', false , @islogical );
p=AddParamValue(p,'colorbar', true , @islogical );
p=AddParamValue(p,'caxis', [] , @isnumeric );
p=AddParamValue(p,'PlotOptions', {} , @iscell );
p=AddParamValue(p,'labels', [], @isnumeric );
p=Parse(p,varargin{:});

R=p.Results;
Th=R.Th;Val=R.Val;

colormap(R.colormap)
ListSubDomLabel=unique(Th.mel);
if ~isempty(R.labels) 
  if isempty(setdiff(R.labels,ListSubDomLabel))
    ListSubDomLabel=R.labels;
  else
    error('Wrong labels');
  end
end

ListSubDomLabel=reshape(ListSubDomLabel,1,length(ListSubDomLabel));

view(3)
if isOctave
%    NumVer=str2num(strrep(version,'.',''));
%    if NumVer<402
%      Cb=nchoosek(1:4,3);
%      ME=[];
%      for i=1:size(Cb,1), ME=[ME;Th.me(Cb(i,:),:)'];end
%    else
%      ME=Th.me';
%      R.shading=false;
%    end
  ME=Th.me';
  R.shading=false;
  % take care 'EdgeAlpha' doesn't work with patch function
  locplot=@(Q,ME,Val) patch('Vertices',Th.q','faces',ME,'CData',mean(Val(ME),2), ...
            'EdgeColor','interp','facecolor','none',R.PlotOptions{:});
%    H=patch('Vertices',Th.q','faces',ME,'CData',mean(Val(ME),2), ...
%              'EdgeColor','interp','facecolor','none',R.PlotOptions{:});
else
  locplot=@(Q,ME,Val) patch('Vertices',Th.q','Faces',ME,'CData',Val,'EdgeColor','interp','FaceColor','none','EdgeAlpha',0.3,R.PlotOptions{:});
  %H=patch('Vertices',Th.q','Faces',Th.me','CData',Val,'EdgeColor','interp','FaceColor','none','EdgeAlpha',0.3,R.PlotOptions{:});
end
PrevHold=SetHoldOn(true);
for i=ListSubDomLabel
  I=find(Th.mel==i);
  H=locplot(Th.q',Th.me(:,I)',R.Val);
end

if nargout==1, h=H;end
%xmin=min(Th.q(1,:));xmax=max(Th.q(1,:));
%ymin=min(Th.q(2,:));ymax=max(Th.q(2,:));
if ~isempty(R.caxis)
    caxis(R.caxis)
end
if R.shading
    shading interp
end
if R.colorbar
    colorbar
end
axis image
axis off
