function [IndLocFaces,IndOpositePt]=getIndLocFaces(d)
%
% returns the array IndLocFaces giving the local numbering of nodes
% of each face in a mesh element (size (d+1,d))
% IndOpositePt gives the local numbering of the node opposite to
% the face (size(d+1,1))
%
  IndLocFaces=nchoosek(1:d+1,d); % local indices for faces of d-simplex
  for i=1:d+1
    IndOpositePt(i)=setdiff(1:d+1,IndLocFaces(i,:)); % indice du point manquant
  end
end