function gmsh_command=command()
% FUNCTION gmsh.command
%   Returns gmsh command as a string.
%
% USAGE:
%   gmsh_command=gmsh.command()
%
% <COPYRIGHT>
  env=mooGmsh.environment();
  if isfield(env,'gmsh_cmd')
    gmsh_command=env.gmsh_cmd;
  else
    error('Unable to find gmsh command with ooGmsh.environment function');
  end
  %[status,result]=system(['export LD_LIBRARY_PATH=;',env.gmsh_cmd,' -version &> /dev/null']);
  [status,result]=system(['export LD_LIBRARY_PATH=;',env.gmsh_cmd,' -version 2>&1 /dev/null']);
  if status~=0, error(result);end
end