classdef ooGmsh < handle  
% CLASSDEF ooGmsh:
%   
%
% <COPYRIGHT>
  properties
    q=[];  % Nodes/Vertices
    dim=3; % Space dimension
    nq=0;  % number of Nodes
    % Ms=[]; % Splitted elements by elmt_type OLD
    sElts=[]; % Splitted elements by elmt_type
    toGlobal=[];
    partitionnedfile=false; % 
    orders = []; % list of orders of the elements
    types =[];   % list of types
  end
  
  methods
    function self=ooGmsh(gmsh_file)
    % ooGmsh constructor, create an ooGmsh object from a gmsh mesh file.
    %   
    % USAGE:
    %   Gh=ooGmsh(gmsh_file);
    %
    % INPUT:
    %   gmsh_file: name (string) of the gmsh mesh file to read.
    %
    % OUTPUT:
    %   Gh: an ooGmsh object.
    %
    % <COPYRIGHT>
      [fid,message]=fopen(gmsh_file,'r');
      if ( fid == -1 )
          error([message,' : ',gmsh_file]);
      end
      while ( 1 )
        text = fgetl ( fid );
        if ( text == -1 )
          error(['string $Nodes not found in file ',gmsh_file])
        end
        if strcmp(strtok(text),'$Nodes')
          break
        end
      end
      nq=fscanf(fid,'%d',1);
      R=fscanf(fid,'%d %f %f %f',[4,nq]);
      self.toGlobal=R(1,:);
      if (min(self.toGlobal)~=1) || (max(self.toGlobal)~=nq), self.partitionnedfile=true;end
      self.q=R(2:end,:);
      if sum(abs(self.q(3,:)))==0,self.q=self.q(1:2,:);self.dim=2;end
      if sum(abs(self.q(2,:)))==0,self.q=self.q(1,:);self.dim=1;end
      self.nq=size(self.q,2);
      while ( 1 )
        text = fgetl ( fid );
        if ( text == -1 )
          error(['string $Elements not found in file ',gmsh_file])
        end
        if strcmp(strtok(text),'$Elements')
          break
        end
      end
      %M=self.getElements(fid);
      self.splitByType(fid);
      self.orders=unique(cell2mat({self.sElts(:).order}));
      self.types=cell2mat({self.sElts(:).type});
    end % ooGmsh constructor
  end % methods
end %

