function meshfile=buildpartrectangle(Lx,Ly,Nx,Ny,N,varargin)
  env=mooGmsh.environment;
  name='rectanglepart';
  geofile=[env.GeoDir,filesep,name,'.geo'];

  p = inputParser;
  p.KeepUnmatched=true; 
  p.addParamValue('meshdir',env.MeshDir,@ischar);
  p.addParamValue('meshfile','',@ischar);
  p.addParamValue('check',false,@islogical);
  p.parse(varargin{:});
  R=p.Results;
  varargin=fcTools.utils.deleteCellOptions(varargin,p.Parameters);
  
  if isempty(R.meshfile) 
    R.meshfile=[R.meshdir,filesep,sprintf('%s-Lx%.3f-Ly%.3f-Nx%d-Ny%d-N%d.msh',name,Lx,Ly,Nx,Ny,N)];
  else
    [pathstr,name,ext] = fileparts(R.meshfile);
    if ~strcmp(ext,'.msh'), warning('Force file extension to .msh');end
    if isempty(pathstr)
      R.meshfile=[R.meshdir,filesep,name,'.msh'];
    else
      R.meshfile=[pathstr,filesep,name,'.msh'];
    end
  end
  if ~exist(R.meshdir)
    [success,message,messageid]=mkdir(R.meshdir);
    if ~success,error(message);end
  end
  if (exist(geofile)~=2), error('File %s not found.',geofile);end

  options={sprintf('-setnumber N %d',N),sprintf('-setnumber NX %d',Nx),sprintf('-setnumber NY %d',Ny), ...
           sprintf('-setnumber LX %g',Lx),sprintf('-setnumber LY %g',Ly),};

  meshfile=gmsh.run(geofile,'d',2,'Loptions',options, ...
                    'meshfile',R.meshfile,varargin{:});
  if R.check
    [status,result]=gmsh.checkmesh(meshfile);
    if status==0
      fprintf('[mooMesh] Check mesh : OK\n')
    else
      fprintf('[mooMesh] Check mesh : Failed\n')
    end
  end
end