function elmt_list=elm_type_list()
% FUNCTION gmsh.elm_type_list
%   Returns a cell array of a structure to obtain informations on 'elm_type' of gmsh.
%
% OUTPUT:
%   elmt_list: cell array such that the i-th elm_type informations are given by
%      elmt_list{i}.elm_type: 
%         number of the element -> i,
%      elmt_list{i}.desc: 
%         description of the element as a string (coming from gmsh manual),
%      elmt_list{i}.nb_nodes: 
%         number of nodes,
%      elmt_list{i}.order: 
%         order of the element,
%      elmt_list{i}.incomplete: 
%         true if incomplete element, false otherwise,
%      elmt_list{i}.d: 
%         minimal space dimension or d-simplex (point, line, triangle, 
%         tetrahedron)
%      elmt_list{i}.geo: 
%         'point', 'line', 'triangle', 'quadrangle', 'tetrahedron', 'prism', 
%         'pyramid' or 'edge'
%
% USAGE:
%   elmt_list=elm_type_list()
%
% <COPYRIGHT>

  settype=@(n,s,nn,order,inc,d,geo) struct('elm_type',n,'desc',s,'nb_nodes',nn,'order',order,'incomplete',inc,'d',d,'geo',geo);
  elmt_list=cell(1,93); % 93 is the biggest elm_type in gmsh manual
  elmt_list{1}=settype(1,'2-node line.',2,1,false,1,'line');
  elmt_list{2}=settype(2,'3-node triangle.',3,1,false,2,'triangle');
  elmt_list{3}=settype(3,'4-node quadrangle.',4,1,false,2,'quadrangle');
  elmt_list{4}=settype(4,'4-node tetrahedron.',4,1,false,3,'tetrahedron');
  elmt_list{5}=settype(5,'8-node hexahedron.',8,1,false,3,'hexahedron');
  elmt_list{6}=settype(6,'6-node prism.',6,1,false,3,'prism');
  elmt_list{7}=settype(7,'5-node pyramid.',5,1,false,3,'pyramid');
  elmt_list{8}=settype(8,'3-node second order line (2 nodes associated with the vertices and 1 with the edge).',3,2,false,1,'line');
  elmt_list{9}=settype(8,'6-node second order triangle (3 nodes associated with the vertices and 3 with the edges).',6,2,false,2,'triangle'); 
  elmt_list{10}=settype(10,'9-node second order quadrangle (4 nodes associated with the vertices, 4 with the edges and 1 with the face).',9,2,false,2,'quadrangle');
  elmt_list{11}=settype(11,'10-node second order tetrahedron (4 nodes associated with the vertices and 6 with the edges).',10,2,false,3,'tetrahedron');
  elmt_list{12}=settype(12,'27-node second order hexahedron (8 nodes associated with the vertices, 12 with the edges, 6 with the faces and 1 with the volume).',27,2,false,3,'hexahedron');
  elmt_list{13}=settype(13,'18-node second order prism (6 nodes associated with the vertices, 9 with the edges and 3 with the quadrangular faces).',18,2,false,3,'prism');
  elmt_list{14}=settype(14,'14-node second order pyramid (5 nodes associated with the vertices, 8 with the edges and 1 with the quadrangular face).',14,2,false,3,'pyramid');
  elmt_list{15}=settype(15,'1-node point.',1,1,false,0,'point');
  elmt_list{16}=settype(16,'8-node second order quadrangle (4 nodes associated with the vertices and 4 with the edges).',8,2,false,2,'quadrangle');
  elmt_list{17}=settype(17,'20-node second order hexahedron (8 nodes associated with the vertices and 12 with the edges).',20,2,false,3,'hexahedron');
  elmt_list{18}=settype(18,'15-node second order prism (6 nodes associated with the vertices and 9 with the edges).',15,2,false,3,'prism');
  elmt_list{19}=settype(19,'13-node second order pyramid (5 nodes associated with the vertices and 8 with the edges).',15,2,false,3,'pyramid');
  elmt_list{20}=settype(20,'9-node third order incomplete triangle (3 nodes associated with the vertices, 6 with the edges)',9,3,true,2,'triangle');
  elmt_list{21}=settype(21,'10-node third order triangle (3 nodes associated with the vertices, 6 with the edges, 1 with the face)',10,3,false,2,'triangle');
  elmt_list{22}=settype(22,'12-node fourth order incomplete triangle (3 nodes associated with the vertices, 9 with the edges)',12,4,true,2,'triangle');
  elmt_list{23}=settype(23,'15-node fourth order triangle (3 nodes associated with the vertices, 9 with the edges, 3 with the face)',15,4,false,2,'triangle');
  elmt_list{24}=settype(24,'15-node fifth order incomplete triangle (3 nodes associated with the vertices, 12 with the edges)',15,5,true,2,'triangle');
  elmt_list{25}=settype(25,'21-node fifth order complete triangle (3 nodes associated with the vertices, 12 with the edges, 6 with the face)',21,5,false,2,'triangle');
  elmt_list{26}=settype(26,'4-node third order edge (2 nodes associated with the vertices, 2 internal to the edge)',4,3,false,2,'edge'); %dim 1 or 2?
  elmt_list{27}=settype(27,'5-node fourth order edge (2 nodes associated with the vertices, 3 internal to the edge)',5,4,false,2,'edge');%dim 1 or 2?
  elmt_list{28}=settype(28,'6-node fifth order edge (2 nodes associated with the vertices, 4 internal to the edge)',6,5,false,2,'edge');%dim 1 or 2?
  elmt_list{29}=settype(29,'20-node third order tetrahedron (4 nodes associated with the vertices, 12 with the edges, 4 with the faces)',20,3,false,3,'tetrahedron');
  elmt_list{30}=settype(30,'35-node fourth order tetrahedron (4 nodes associated with the vertices, 18 with the edges, 12 with the faces, 1 in the volume)',35,4,false,3,'tetrahedron');
  elmt_list{31}=settype(31,'56-node fifth order tetrahedron (4 nodes associated with the vertices, 24 with the edges, 24 with the faces, 4 in the volume)',56,5,false,3,'tetrahedron');
  elmt_list{92}=settype(92,'64-node third order hexahedron (8 nodes associated with the vertices, 24 with the edges, 24 with the faces, 8 in the volume)',64,3,false,3,'hexahedron');
  elmt_list{93}=settype(93,'125-node fourth order hexahedron (8 nodes associated with the vertices, 36 with the edges, 54 with the faces, 27 in the volume)',125,4,false,3,'hexahedron'); 
end