function env=environment(varargin)
% FUNCTION env=mooGmsh.environment()
%   Retrieves the toolbox/package environment directories.
%
% <COPYRIGHT>
  p = inputParser;
  p.addParamValue('run_command',true,@islogical);
  p.parse(varargin{:});
  run_command=p.Results.run_command;
  fullname=mfilename('fullpath');
  I=strfind(fullname,filesep);
  env.Path=fullname(1:(I(end-1)-1));
  locfile=[env.Path,filesep,'environment_loc.m'];
  [fid,message]=fopen(locfile,'r');
  if ( fid == -1 ), bool=false;else bool=true;fclose(fid); end
  if bool
    environment_loc
    env.MeshDir=MeshDir;
    env.GeoDir=GeoDir;
    env.gmsh_cmd=gmsh_cmd;
    if run_command
      env.fctools=fcTools.init();
    else
      env.fctools=fullname(1:I(end-2));
    end
  else % default values
    fprintf('[fc-oogmsh] Using default environment! Use ooGmsh.configure if needed.\n')
    env.MeshDir=[env.Path,filesep,'meshes'];
    env.GeoDir=[env.Path,filesep,'geodir'];
    env.gmsh_cmd='gmsh';
    env.fctools=[fullname(1:I(end-2)),'fc-tools'];
  end
end


function mypath=TryGuessPath(toolbox_name,fun_check)
  fullname=mfilename('fullpath');
  I=strfind(fullname,filesep);
  
  mypath=[fullname(1:(I(end-2))),toolbox_name];
  addpath(mypath)
  if ~check_toolbox(fun_check)
    rmpath(mypath)
    mypath=[];
  end
end

function bool=check_toolbox(fun_check)
  try bool=true;fun_check();catch bool=false;end
end