function M=getElements(self,fid)
% FUNCTION getElements, method function of the ooGmsh class.
%   Internal. Must be private in future release.
%
% <COPYRIGHT>
  if fcTools.comp.isOctave()
    M=getElements_Octave(fid);
  else
    M=getElements_Matlab(fid);
  end
end

function M=getElements_Octave(fid) % Must be improved 
  nelem=fscanf(fid,'%d',1);
  M=zeros(nelem,55); % 55 a ameliorer
  fgetl(fid);
  for i=1:nelem
    A=sscanf(fgetl(fid),'%d')';
    %nM(i)=numel(A);
    M(i,1:numel(A))=A;
  end
end

function M=getElements_Matlab(fid)% Must be improved 
  nelem=fscanf(fid,'%d',1);
  format = repmat('%d',1,55); % 55 a ameliorer
  R = textscan(fid,format,nelem);
  M = [R{:}];
end