function self=splitByType(self,fid)
% FUNCTION splitByType, method function of the ooGmsh class.
%   Internal. Must be private in future release.
%
% <COPYRIGHT>

% elm-number elm-type number-of-tags < tag > ... node-number-list
%  number-of-tags :
%    gives the number of integer tags that follow for the n-th element. By default,
%    the first tag is the number of the physical entity to which the element belongs;
%    the second is the number of the elementary geometrical entity to which the
%    element belongs; the third is the number of mesh partitions to which the element
%    belongs, followed by the partition ids (negative partition ids indicate ghost
%    cells). A zero tag is equivalent to no tag. Gmsh and most codes using the MSH
%    2 format require at least the first two tags (physical and elementary tags).
  elm_types=gmsh.elm_type_list();
  Mt=self.getElements(fid); % Get All elements
  index=struct('num',1,'elm_type',2,'nb_tags',3,'phys_lab',4,'geo_lab',5,'nb_parts',6);
  Ltype=unique(Mt(:,index.elm_type)); % gets all elm_type of the meshes
  self.sElts=cell(length(Ltype),1); % Will converted in struct array 
  for i=1:length(Ltype)
    I=find(Mt(:,index.elm_type)==Ltype(i));
    M=double(Mt(I,:));
    type=Ltype(i);
    order=elm_types{type}.order;
    geo=elm_types{type}.geo;
    d=elm_types{type}.d;
    nme=length(I);
    nTags=M(:,index.nb_tags)-3; % Tags number other that 'phys_lab' and 'geo_lab', if num<=0 => no tags
    PhysicalLabel=M(:,index.phys_lab);
    GeometricalLabel=M(:,index.geo_lab);
    nMeshPart=zeros(nme,1); % number of mesh partitions to which the element belongs
    MeshPart=[];  
    K=find(nTags>=0); % index of elmts with partition ids
    if ~isempty(K), 
      Kc=setdiff(1:nme,K); % index of elmts without partition ids
      nMeshPart(K)=M(K,index.nb_parts);
      MeshPart=zeros(nme,max(nTags)); % Don't store  'phys_lab','geo_lab' and 'nb_parts'
    else
      Kc=1:nme;
    end
    ndfe=elm_types{type}.nb_nodes;
    me=zeros(ndfe,nme);
    % read elmts without partition ids
    if ~isempty(Kc)
      me(:,Kc)=M(Kc,index.geo_lab+[1:ndfe])';
    end
    
    % read elmts with partition ids
    K=K';
    lnTags=unique(nTags(K)); % list of number of partitions 
    
    for j=1:numel(lnTags)
      nt=lnTags(j);
      ik=find(nTags(K)==nt);
      k=K(ik);
      MeshPart(k,1:nt)=M(k,index.nb_parts+[1:nt]);
      me(:,k)=M(k,index.nb_parts+nt+[1:ndfe])';
    end
    self.sElts{i}=elt_struct(d,me,nme,type,order,geo,PhysicalLabel,GeometricalLabel,nMeshPart,MeshPart,nTags);
  end
  self.sElts=cell2mat(self.sElts);
end

function elt=elt_struct(d,me,nme,type,order,geo,PhysicalLabel,GeometricalLabel,nMeshPart,MeshPart,nTags)
  elt=struct('type',type,'geo',geo,'d',d,'order',order,'me',me,'nme',nme,'phys_lab',PhysicalLabel, ...
             'geo_lab',GeometricalLabel,'part_lab',MeshPart,'nb_parts',nMeshPart);
end