function configure()
% FUNCTION mooGmsh.configure()
%   Configures the toolbox/package by setting gmsh path, meshes default 
%   directory and .geo files default directory.
%   Theses informations will be stored in +ooGmsh/environment_loc.m file.
%
% <COPYRIGHT>
  env=mooGmsh.environment('run_command',false);
  fprintf('Configuration of ooGmsh toolbox\n');
  fprintf('1) Select gmsh binary ...\n'); 
  [gmsh_bin, gmsh_dir]=uigetfile('*','Select GMSH binary',env.gmsh_cmd);
  fprintf('2) Select <geo> files directory ...\n'); 
  geodir=uigetdir(env.GeoDir,'Select <geo> files directory');
  fprintf('3) Select <msh> files directory ...\n'); 
  meshdir=uigetdir(env.MeshDir,'Select <msh> files directory');
  fprintf('4) Check needed toolboxes ...\n');
  command=[];
  if check_toolbox('fcTools.version')
    fprintf('   -> <fc-tools> [%s] toolbox/package already in path\n',fcTools.version())
    fctools=fcTools.init();
    fprintf('      %s\n',fctools)
  else
    command=TryGuess('fc-tools','fcTools.version');
    fctools=[];
    if isempty(command)
      fctools=uigetdir(env.fctools,'Select <fc-tools> toolbox/package');
    end
  end
  %File=[env.Path,filesep,'+mooGmsh',filesep,'environment_loc.m'];
  File=[env.Path,filesep,'environment_loc.m'];
  fprintf('Write in %s ...\n',File);
  fid=fopen(File,'w');
  if (fid==0), error('Unable to open file :\n %s\n',File);end
  fprintf(fid,'%% Automaticaly generated with ooGmsh.configure()\n');
  fprintf(fid,'gmsh_cmd=''%s'';\n',[gmsh_dir,filesep,gmsh_bin]);
  fprintf(fid,'MeshDir=''%s'';\n',meshdir);
  fprintf(fid,'GeoDir=''%s'';\n',geodir);
  fprintf(fid,'if run_command\n');
  if isempty(command)
    fprintf(fid,'addpath %s\n',fctools);
  else
    fprintf(fid,'%s\n',command);
  end
  fprintf(fid,'end\n');
  fclose(fid);
  fprintf('  -> done\n');
end

function bool=check_toolbox(sfun_check) %sfun_check='fcTools.version' for example
  try bool=true;eval(sfun_check);catch bool=false;end
end

function command=TryGuess(toolbox_name,sfun_check)
  command=[];
  log=ver;
  isOctave=strcmp(log(1).Name,'Octave');
  if isOctave % try pkg load
    Lp=pkg('list');
    if sum(cellfun(@(x) strcmp(x.name,toolbox_name),Lp))==1 % package is installed
      command=['pkg load ',toolbox_name];
      return
    end
  else
    fullname=mfilename('fullpath');
    I=strfind(fullname,filesep);
    mypath=[fullname(1:(I(end-2))),toolbox_name];
    addpath(mypath)
    if check_toolbox(sfun_check)
      command=['addpath ',mypath];
    end
    rmpath(mypath)
  end
end