function c = colorstr2rgb(c)
% FUNCTION fcTools.graphics.colorstr2rgb 
%   Convert a color string to an RGB value.
%
%    Parts of Matlab <fc-tools> toolbox.
%    Copyright (C) 2016 Francois Cuvelier <cuvelier@math.univ-paris13.fr>
%
  if ~ischar(c);return;end
  rgbspec = [1 0 0;0 1 0;0 0 1;1 1 1;0 1 1;1 0 1;1 1 0;0 0 0];
  cspec = 'rgbwcmyk';
  k = find(cspec==c(1));
  if isempty(k)
    error('MATLAB:InvalidColorString','Unknown color string.');
  end
  if k~=3 || length(c)==1,
    c = rgbspec(k,:);
  elseif length(c)>2,
    if strcmpi(c(1:3),'bla')
      c = [0 0 0];
    elseif strcmpi(c(1:3),'blu')
      c = [0 0 1];
    else
      error('MATLAB:UnknownColorString', 'Unknown color string.');
    end
  end
end