function colors = selectColors(n_colors,varargin)
%  FUNCTION fc_tools.graphics.selectColors
%
%    Inspired by the function select_colors (or distinguishable_colors) of
%    Timothy E. Holy 
%
%    RGB2LAB est une fonction locale (attention une autre fonction rgb2lab 
%    figure dans la Image Processing Toolbox R2015a,...) qui sert a la gestion
%    des couleurs via le format lab.
%
%    Objet: création de couleurs pertinentes
%    background permet d'éliminer des couleurs
%    func est la fonction de conversion des couleurs
%
%    Parts of GNU Octave <fc-tools> package.
%    Copyright (C) 2016 Francois Cuvelier <cuvelier@math.univ-paris13.fr>
%
  p = inputParser;
  p.addParamValue('background', [1 1 1; 0 0 0; 0.8 0.8 0.8;1,0,1], @isnumeric );
  p.addParamValue('func', @RGB2LAB );
  p.parse(varargin{:});

  bg=p.Results.background;
  func=p.Results.func;
  % Generate a sizable number of RGB triples. This represents our space of
  % possible choices. By starting in RGB space, we ensure that all of the
  % colors can be generated by the monitor.
  n_grid = 30;  % number of grid divisions along each axis in RGB space
  x = linspace(0,1,n_grid);
  [R,G,B] = ndgrid(x,x,x);
  rgb = [R(:) G(:) B(:)];
  if (n_colors > size(rgb,1)/3)
    error('You can''t readily distinguish that many colors');
  end
  
  % Convert to Lab color space, which more closely represents human
  % perception
  lab = func(rgb);
  bglab = func(bg);

  % If the user specified multiple background colors, compute distances
  % from the candidate colors to the background colors
  mindist2 = inf(size(rgb,1),1);
  for i = 1:size(bglab,1)-1
    dX = bsxfun(@minus,lab,bglab(i,:)); % displacement all colors from bg
    dist2 = sum(dX.^2,2);  % square distance
    mindist2 = min(dist2,mindist2);  % dist2 to closest previously-chosen color
  end
  
  % Iteratively pick the color that maximizes the distance to the nearest
  % already-picked color
  colors = zeros(n_colors,3);
  lastlab = bglab(end,:);   % initialize by making the "previous" color equal to background
  for i = 1:n_colors
    dX = bsxfun(@minus,lab,lastlab); % displacement of last from all colors on list
    dist2 = sum(dX.^2,2);  % square distance
    mindist2 = min(dist2,mindist2);  % dist2 to closest previously-chosen color
    [~,index] = max(mindist2);  % find the entry farthest from all previously-chosen colors
    colors(i,:) = rgb(index,:);  % save for output
    lastlab = lab(index,:);  % prepare for next iteration
  end
end

function [LAB]=RGB2LAB(RGB)
% by F.C.
  XYZ=RGB2XYZ(RGB);
  LAB=XYZ2LAB(XYZ);
end

function XYZ=RGB2XYZ(RGB)
% by F.C.
N=size(RGB,1);
%var_R = ( RGB(:,1)  );        %R from 0 to 1
%var_G = ( RGB(:,2)  );        %G from 0 to 1
%var_B = ( RGB(:,3)  );        %B from 0 to 1

for i=1:3
  I=find(RGB(:,i) > 0.0404482362771076);
  RGB(I,i) = ( ( RGB(I,i) + 0.055 ) / 1.055 ).^ 2.4;
  I=setdiff(1:N,I);
  RGB(I,i) = RGB(I,i) / 12.92;
end

% Observer. = 2°, Illuminant = D65
%  X = var_R * 0.4124 + var_G * 0.3576 + var_B * 0.1805;
%  Y = var_R * 0.2126 + var_G * 0.7152 + var_B * 0.0722;
%  Z = var_R * 0.0193 + var_G * 0.1192 + var_B * 0.9505;
A=[0.4123955889674142161,0.3575834307637148171,0.1804926473817015735; ...
   0.2125862307855955516,0.7151703037034108499,0.07220049864333622685; ...
   0.01929721549174694484,0.1191838645808485318,0.9504971251315797660]';
XYZ=RGB*A;
end

function [LAB]=XYZ2LAB(XYZ)
  WHITEPOINT_X=0.950456;
  WHITEPOINT_Y=1.0;
  WHITEPOINT_Z=1.088754;
  X=XYZ(:,1)/WHITEPOINT_X;
  Y=XYZ(:,2)/WHITEPOINT_Y;
  Z=XYZ(:,3)/WHITEPOINT_Z;

  N=size(XYZ,1);
  LAB=zeros(N,3);

  X = LABF(X);
  Y = LABF(Y);
  Z = LABF(Z);
  LAB(:,1) = 116*Y - 16;
  LAB(:,2) = 500*(X - Y);
  LAB(:,3) = 200*(Y - Z);
end

function z=LABF(t)
  N=length(t);z=0*t;
  I=find(t >= 8.85645167903563082e-3);
  z(I)=t(I).^(0.333333333333333);
  I=setdiff(1:N,I);
  z(I)=(841.0/108.0)*(t(I)) + (4.0/29.0);
end